/*
    Copyright  1995-2001, The AROS Development Team. All rights reserved.
    $Id: libfunc.c,v 1.1.1.1 2005/03/15 16:00:54 laire Exp $
*/

#include <proto/exec.h>
#include <proto/intuition.h>
#include "compilerspecific.h"
#include "ascii_intern.h"
#include "libdefs.h"

#undef DEBUG
#define DEBUG 0
#include <aros/debug.h>

/**************************************************************************************************/

#warning "All this global stuff sucks and should be removed"
struct ExecBase 	*SysBase;
struct IntuitionBase 	*IntuitionBase;
struct GfxBase	 	*GfxBase;
#ifdef _AROS
#ifdef __MORPHOS__
struct Library		*UtilityBase;
#else
struct UtilityBase	*UtilityBase;
#endif
#else
struct Library		*UtilityBase;
#endif
struct DosLibrary 	*DOSBase;
struct Library 		*DataTypesBase;
struct Library 		*IFFParseBase;
struct Library		*TextBase;

/* inside asciiclass.c */
struct IClass *DT_MakeClass(LIBBASETYPEPTR	LIBBASE);

/**************************************************************************************************/

#ifdef __MORPHOS__
int __UserLibInit(LIBBASETYPEPTR	LIBBASE )
#else
ASM SAVEDS int __UserLibInit( register __a6 LIBBASETYPEPTR	LIBBASE )
#endif
{

    SysBase = LIBBASE->sysbase;

    D(bug("ascii.datatype/__UserLibInit\n"));
    
    if ((TextBase = OpenLibrary("datatypes/text.datatype", 0)))
    {
	if((GfxBase = (struct GfxBase *)OpenLibrary("graphics.library", 39)))
	{
	    if((IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library", 39)))
	    {
		if((DOSBase = (struct DosLibrary *)OpenLibrary("dos.library", 39)))
		{
#ifdef _AROS
		    if((UtilityBase = (struct UtilityBase *)OpenLibrary("utility.library", 37)))
#else
		    if((UtilityBase = (struct Library *)OpenLibrary("utility.library", 37)))
#endif
		    {
			if((DataTypesBase = OpenLibrary("datatypes.library", 37)))
			{
			    if((IFFParseBase = OpenLibrary("iffparse.library", 37)))
			    {
				if((LIBBASE->class = DT_MakeClass(LIBBASE)))
				{
				    AddClass(LIBBASE->class);

   				    D(bug("ascii.datatype/__UserLibInit: Returning success\n"));

				    return 0;
				}
			    }
			}
		    }
		}
	    }
	}
    }

    D(bug("ascii.datatype/__UserLibInit: Returning failure\n"));
    
    return -1;
}

/**************************************************************************************************/

#ifdef __MORPHOS__
void __UserLibCleanup(LIBBASETYPEPTR	LIBBASE )
#else
ASM SAVEDS void __UserLibCleanup( register __a6 LIBBASETYPEPTR	LIBBASE )
#endif
{
    D(bug("ascii.datatype/__UserLibCleanup\n"));

    D(bug("ascii.datatype/__UserLibCleanup: Freeing class\n"));

    if(LIBBASE->class)
    {
	RemoveClass(LIBBASE->class);
	FreeClass(LIBBASE->class);
	LIBBASE->class = NULL;
    }

    D(bug("ascii.datatype/__UserLibCleanup: Closing Libraries\n"));

    if(TextBase) CloseLibrary(TextBase);
    if(IFFParseBase) CloseLibrary(IFFParseBase);
    if(DataTypesBase) CloseLibrary(DataTypesBase);
    if(UtilityBase) CloseLibrary((struct Library *)UtilityBase);
    if(DOSBase) CloseLibrary((struct Library *)DOSBase);
    if(IntuitionBase) CloseLibrary((struct Library *)IntuitionBase);
    if(GfxBase) CloseLibrary((struct Library *)GfxBase);
    
    D(bug("ascii.datatype/__UserLibCleanup: Done\n"));

}

/**************************************************************************************************/

SAVEDS STDARGS struct IClass *ObtainEngine(LIBBASETYPEPTR	LIBBASE)
{
    D(bug("ascii.datatype/ObtainEngine: returning %x\n", LIBBASE->class));

    return (LIBBASE->class);
}

/**************************************************************************************************/
